/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.stick;

import de.z0rdak.yawp.core.INbtSerializable;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.stick.AbstractStick;
import de.z0rdak.yawp.util.NbtCompatHelper;
import de.z0rdak.yawp.util.StickType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class MarkerStick
extends AbstractStick
implements INbtSerializable<class_2487> {
    private class_5321<class_1937> dimension;
    private AreaType areaType;
    private boolean isValidArea;
    private List<class_2338> markedBlocks;

    public MarkerStick(class_5321<class_1937> dim) {
        super(StickType.MARKER);
        this.areaType = AreaType.CUBOID;
        this.isValidArea = false;
        this.markedBlocks = new ArrayList<class_2338>(this.areaType.maxBlocks);
        this.dimension = dim;
    }

    public MarkerStick(class_2487 nbt) {
        super(StickType.MARKER);
        this.deserializeNBT(nbt);
    }

    @Override
    public void cycleMode() {
        this.areaType = AreaType.values()[(this.areaType.ordinal() + 1) % AreaType.values().length];
        this.reset();
    }

    public void reset() {
        this.markedBlocks = new ArrayList<class_2338>(this.areaType.maxBlocks);
        this.isValidArea = false;
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    public boolean checkValidArea() {
        int numMarkedBlocks = this.markedBlocks.size();
        if (this.markedBlocks.isEmpty() || this.areaType.neededBlocks == -1) {
            return false;
        }
        boolean exactlyEnoughBlocks = numMarkedBlocks == this.areaType.neededBlocks && numMarkedBlocks == this.areaType.maxBlocks;
        boolean minBlocks = numMarkedBlocks >= this.areaType.neededBlocks && numMarkedBlocks <= this.areaType.maxBlocks;
        this.isValidArea = exactlyEnoughBlocks || minBlocks;
        return this.isValidArea;
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
    }

    public boolean isValidArea() {
        return this.isValidArea;
    }

    public List<class_2338> getMarkedBlocks() {
        return this.markedBlocks;
    }

    public void addMarkedBlock(class_2338 pos) {
        int index = this.markedBlocks.size() % this.areaType.maxBlocks;
        this.markedBlocks.add(index, pos);
        if (this.markedBlocks.size() > this.areaType.maxBlocks) {
            this.markedBlocks.remove(this.areaType.maxBlocks);
        }
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = super.serializeNBT();
        nbt.method_10582("stick-id", UUID.randomUUID().toString());
        nbt.method_10556("valid", this.isValidArea);
        nbt.method_10582("type", this.areaType.areaType);
        nbt.method_10582("dim", this.dimension.method_29177().toString());
        class_2499 blocks = new class_2499();
        this.markedBlocks.forEach(block -> blocks.add((Object)class_2512.method_10692((class_2338)block)));
        nbt.method_10566("blocks", (class_2520)blocks);
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
        this.isValidArea = nbt.method_10577("valid");
        this.areaType = AreaType.of(nbt.method_10558("type"));
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)nbt.method_10558("dim")));
        class_2499 markedBlocksNBT = (class_2499)nbt.method_10580("blocks");
        if (markedBlocksNBT != null) {
            this.markedBlocks = new ArrayList<class_2338>(this.areaType.maxBlocks);
            for (int i = 0; i < markedBlocksNBT.size(); ++i) {
                int[] intArray = markedBlocksNBT.method_36111(i);
                class_2495 intArrayTag = new class_2495(intArray);
                NbtCompatHelper.toBlockPos(intArrayTag).ifPresent(pos -> this.markedBlocks.add((class_2338)pos));
            }
        }
    }
}

